#include "PacketDef.h"

tPacketDef gPacketDef[] =
{ { 0x00, "Unknown packet ($%2.2X).", "I" },
  { 0x01, "Program reset", "" },
  { 0x02, "TCP Packet Start Receive", "" },
  { 0x03, "PPP received data = $%2.2X %d '%c'", "III" },
  { 0x04, "PPP unknown event = %s (%d)", "S[PPPEvents]I" },
  { 0x05, "PPP IP layer up", "" },
  { 0x06, "PPP closed", "" },
  { 0x07, "PPP state = %s (%d)", "S[PPPRxStates]I" },
  { 0x08, "PPP send packet ($%2.2X)", "I" },
  { 0x09, "PPP gobble packet", "" },
  { 0x0A, "PPP transmit data = $%2.2X '%c'", "II" },
  { 0x0B, "PPP open", "" },
  { 0x0C, "PPP receive packet", "" },
  { 0x0D, "PPP state = %s (%d)", "S[PPPStates]I" },
  { 0x0E, "PPP RxData", "" },
  { 0x0F, "PPP send conf-rej", "" },
  { 0x10, "PPP send conf-ack", "" },
  { 0x11, "PPP error", "" },
  { 0x12, "PPP no peer", "" },
  { 0x13, "UART receive buffer overflow", "" },
  
  { 0x14, "TCP state = %s (%d)", "S[TCPStates]I" },
  { 0x15, "TCP flags = %s (%d)", "S[TCPFlags]I" },
  { 0x16, "TCP ignoring packet (ports don't match)", "" },
  { 0x17, "TCP send command = %s (%d)", "S[TCPFlags]I" },
  { 0x18, "TCP bad PPP FCS", "" },
  { 0x19, "TCP packet data = $%2.2X %d '%c'", "III" },
  { 0x1A, "TCP payload start", "" },
  { 0x1B, "TCP payload end", "" },
  { 0x1C, "TCP closing", "" },
  { 0x1D, "TCP packet larger than window", "" },
  { 0x1E, "TCP received reset in Syn-Sent state", "" },
  { 0x1F, "TCP no ACK in Syn-Sent state", "" },
  { 0x20, "TCP ACKing in Syn-Sent state", "" },
  { 0x21, "TCP sending reset", "" },
  { 0x22, "TCP sending SYN", "" },
  { 0x23, "TCP sending ACK", "" },
  { 0x24, "TCP retransmit packet", "" },
  { 0x25, "TCP bytes outstanding = %d", "I" },
  { 0x26, "TCP application wants to transmit %d bytes", "I" },
  { 0x27, "TCP acked but outstanding bytes!", "" },
  { 0x28, "TCP got FIN, closing", "" },
  { 0x29, "TCP sending FIN", "" },
  { 0x2A, "TCP checksum byte = $%2.2X %d '%c'", "III" },

  { 0x30, "SMTP error code $%2.2X", "I" },
  { 0x31, "SMTP state = %s (%d)", "S[SMTPStates]I" },
  { 0x32, "SMTP count = %d", "I" },
  { 0x33, "SMTP command = $%2.2X %d)", "II" },

  { 0x50, "AppInit", "" },
  { 0x51, "AppBytesToSend = %d", "I" },
  { 0x52, "AppBytesAvailable = %d", "I" },
  { 0x53, "AppNak", "" },
  { 0x54, "AppAck", "" },
  { 0x55, "AppTxByte", "" },
  { 0x56, "AppRxByte", "" },
  { 0x57, "AppPacketOK", "" },
  { 0x58, "AppPacketBad", "" },

  { 0x60, "HTTP 404 File not found %d $%2.2X", "II" },
  { 0x61, "HTTP EEPROM error", "" },
  { 0x62, "EEPROM Read complete", "" },
  { 0x64, "HTTP URI hash = %d $%2.2X", "II" },
  { 0x65, "HTTP URI parse state = %s (%d)", "S[HTTPParseState]I" },

  { 0x70, "FCS rx data ($%2.2X)", "I" },

  { kLastID, "" }
};

tStringDef gStringDef[] =
{ { "PPPEvents", 0, "PPP_NONE" },
  { "PPPEvents", 1, "-" },
  { "PPPEvents", 2, "PPP_RCA" },
  { "PPPEvents", 3, "PPP_RCN" },
  { "PPPEvents", 4, "PPP_RTR" },
  { "PPPEvents", 5, "PPP_RTA" },
  { "PPPEvents", 6, "PPP_RUC" },
  { "PPPEvents", 7, "PPP_RXJ_GOOD" },
  { "PPPEvents", 8, "PPP_RXJ_BAD" },
  { "PPPEvents", 9, "PPP_RXR" },
  { "PPPEvents", 10, "PPP_RCR_GOOD" },
  { "PPPEvents", 11, "PPP_RCR_BAD" },
  { "PPPEvents", 12, "PPP_TO_GOOD" },
  { "PPPEvents", 13, "PPP_TO_BAD" },
  { "PPPEvents", 14, "PPP_DATA" },

  { "PPPStates", 0, "Initial" },
  { "PPPStates", 1, "Starting" },
  { "PPPStates", 2, "Closed" },
  { "PPPStates", 3, "Stopped" },
  { "PPPStates", 4, "Closing" },
  { "PPPStates", 5, "Stopping" },
  { "PPPStates", 6, "ReqSent" },
  { "PPPStates", 7, "AckRcvd" },
  { "PPPStates", 8, "AckSent" },
  { "PPPStates", 9, "Opened" },
  
  { "PPPRxStates", 0, "Flag" },
  { "PPPRxStates", 1, "Address" },
  { "PPPRxStates", 2, "Control" },
  { "PPPRxStates", 3, "Proto1" },
  { "PPPRxStates", 4, "Proto2" },
  { "PPPRxStates", 5, "LCPCode" },
  { "PPPRxStates", 6, "LCPID" },
  { "PPPRxStates", 7, "LCPLen1" },
  { "PPPRxStates", 8, "LCPLen2" },
  { "PPPRxStates", 9, "Data" },
  { "PPPRxStates", 10, "FCS1" },
  { "PPPRxStates", 11, "FCS2" },
  { "PPPRxStates", 12, "UnknownCode" },

  { "TCPStates", 0, "Closed" },
  { "TCPStates", 1, "Listen" },
  { "TCPStates", 2, "SynSent" },
  { "TCPStates", 3, "SynReceived" },
  { "TCPStates", 4, "Established" },
  { "TCPStates", 5, "FinWait1" },
  { "TCPStates", 6, "FinWait2" },
  { "TCPStates", 7, "CloseWait" },
  { "TCPStates", 8, "Closing" },
  { "TCPStates", 9, "LastAck" },
  { "TCPStates", 10, "TimeWait" },

  { "TCPFlags", 0, "-" },
  { "TCPFlags", 1, "FIN" },
  { "TCPFlags", 2, "SYN" },
  { "TCPFlags", 3, "SYN + FIN" },
  { "TCPFlags", 4, "RST" },
  { "TCPFlags", 8, "PSH" },
  { "TCPFlags", 16, "ACK" },
  { "TCPFlags", 17, "ACK + FIN" },
  { "TCPFlags", 18, "ACK + SYN" },
  { "TCPFlags", 24, "ACK + PSH" },
  { "TCPFlags", 32, "URG" },

  { "SMTPStates", 0, "Closed" },
  { "SMTPStates", 1, "Hello" },
  { "SMTPStates", 2, "HelloAck" },
  { "SMTPStates", 3, "Mail" },
  { "SMTPStates", 4, "MailAck" },
  { "SMTPStates", 5, "Rcpt" },
  { "SMTPStates", 6, "RcptAck" },
  { "SMTPStates", 7, "Data" },
  { "SMTPStates", 8, "DataAck" },
  { "SMTPStates", 9, "Mesg" },
  { "SMTPStates", 10, "MesgAck" },
  { "SMTPStates", 11, "Quit" },
  { "SMTPStates", 12, "QuitAck" },
  { "SMTPStates", 13, "Finished" },

  { "HTTPParseState", 0, "Method" },
  { "HTTPParseState", 1, "URI" },
  { "HTTPParseState", 2, "Version" },
  { "HTTPParseState", 3, "Header" },
  { "HTTPParseState", 4, "Finished" },
  { "HTTPParseState", 5, "1" },
  { "HTTPParseState", 6, "2" },
  { "HTTPParseState", 7, "3" },
  { "HTTPParseState", 8, "4" },

  { 0L, 0, 0L }
};
